<?php

/**
 * ---------------------------------------------------------------------
 *
 * GLPI - Gestionnaire Libre de Parc Informatique
 *
 * http://glpi-project.org
 *
 * @copyright 2015-2025 Teclib' and contributors.
 * @copyright 2003-2014 by the INDEPNET Development Team.
 * @licence   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * ---------------------------------------------------------------------
 *
 * LICENSE
 *
 * This file is part of GLPI.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * ---------------------------------------------------------------------
 */

$AJAX_INCLUDE = 1;
include('../inc/includes.php');

header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

Session::checkRight('user', User::UPDATEAUTHENT);

if ($_POST["authtype"] > 0) {
    $name = $_POST['name'] ?? 'massiveaction';

    switch ($_POST["authtype"]) {
        case Auth::DB_GLPI:
            echo "<input type='hidden' name='auths_id' value='0'>";
            break;

        case Auth::LDAP:
        case Auth::EXTERNAL:
            AuthLDAP::dropdown([
                'name'      => "auths_id",
                'condition' => ['is_active' => 1]
            ]);
            break;

        case Auth::MAIL:
            AuthMail::dropdown([
                'name'      => "auths_id",
                'condition' => ['is_active' => 1]
            ]);
            break;
    }

    echo "&nbsp;<input type='submit' name='$name' class='btn btn-primary' value=\"" . _sx('button', 'Post') . "\">";
}
